@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.TriggerPredicateConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crawlState The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
 * @property crawlerName The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
 * @property jobName The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
 * @property logicalOperator A logical operator. Defaults to `EQUALS`.
 * @property state The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
 */
public data class TriggerPredicateConditionArgs(
    public val crawlState: Output<String>? = null,
    public val crawlerName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val logicalOperator: Output<String>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.TriggerPredicateConditionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.TriggerPredicateConditionArgs =
        com.pulumi.aws.glue.inputs.TriggerPredicateConditionArgs.builder()
            .crawlState(crawlState?.applyValue({ args0 -> args0 }))
            .crawlerName(crawlerName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .logicalOperator(logicalOperator?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerPredicateConditionArgs].
 */
@PulumiTagMarker
public class TriggerPredicateConditionArgsBuilder internal constructor() {
    private var crawlState: Output<String>? = null

    private var crawlerName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var logicalOperator: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
     */
    @JvmName("qokslhafbdutvksf")
    public suspend fun crawlState(`value`: Output<String>) {
        this.crawlState = value
    }

    /**
     * @param value The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
     */
    @JvmName("kwgwfkmbmhwlqjfb")
    public suspend fun crawlerName(`value`: Output<String>) {
        this.crawlerName = value
    }

    /**
     * @param value The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
     */
    @JvmName("srwgimrbftokiytd")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value A logical operator. Defaults to `EQUALS`.
     */
    @JvmName("nmoxprwgomyatyfu")
    public suspend fun logicalOperator(`value`: Output<String>) {
        this.logicalOperator = value
    }

    /**
     * @param value The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
     */
    @JvmName("frfnqcmpywdwptbk")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The condition crawl state. Currently, the values supported are `RUNNING`, `SUCCEEDED`, `CANCELLED`, and `FAILED`. If this is specified, `crawler_name` must also be specified. Conflicts with `state`.
     */
    @JvmName("mreirespctdcyvuu")
    public suspend fun crawlState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlState = mapped
    }

    /**
     * @param value The name of the crawler to watch. If this is specified, `crawl_state` must also be specified. Conflicts with `job_name`.
     */
    @JvmName("ncdaxiyedbtgbupx")
    public suspend fun crawlerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlerName = mapped
    }

    /**
     * @param value The name of the job to watch. If this is specified, `state` must also be specified. Conflicts with `crawler_name`.
     */
    @JvmName("ovvxuqcoiblxcavo")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value A logical operator. Defaults to `EQUALS`.
     */
    @JvmName("oopiplkllajspnhq")
    public suspend fun logicalOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalOperator = mapped
    }

    /**
     * @param value The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
     */
    @JvmName("vjwxtiotxwdxdtlv")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): TriggerPredicateConditionArgs = TriggerPredicateConditionArgs(
        crawlState = crawlState,
        crawlerName = crawlerName,
        jobName = jobName,
        logicalOperator = logicalOperator,
        state = state,
    )
}
