@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceType The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
 * @property uri The URI for accessing the resource.
 */
public data class UserDefinedFunctionResourceUriArgs(
    public val resourceType: Output<String>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs =
        com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs.builder()
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserDefinedFunctionResourceUriArgs].
 */
@PulumiTagMarker
public class UserDefinedFunctionResourceUriArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
     */
    @JvmName("tpwplyhbiajfgdus")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The URI for accessing the resource.
     */
    @JvmName("omnaeiqokwrogkgv")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
     */
    @JvmName("eacjgdevbwfjtxoy")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The URI for accessing the resource.
     */
    @JvmName("actywjqvgwbjhkka")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): UserDefinedFunctionResourceUriArgs = UserDefinedFunctionResourceUriArgs(
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
