@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionName Name of the connection to the external metastore.
 * @property identifier Unique identifier for the federated database.
 */
public data class CatalogDatabaseFederatedDatabase(
    public val connectionName: String? = null,
    public val identifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogDatabaseFederatedDatabase): CatalogDatabaseFederatedDatabase = CatalogDatabaseFederatedDatabase(
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
