@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metadataOperation A required metadata operation. Can only be set to CREATE.
 * @property version The table version for the Iceberg table. Defaults to 2.
 */
public data class CatalogTableOpenTableFormatInputIcebergInput(
    public val metadataOperation: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableOpenTableFormatInputIcebergInput): CatalogTableOpenTableFormatInputIcebergInput = CatalogTableOpenTableFormatInputIcebergInput(
            metadataOperation = javaType.metadataOperation(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
