@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property additionalLocations List of locations that point to the path where a Delta table is located.
 * @property bucketColumns List of reducer grouping columns, clustering columns, and bucketing columns in the table.
 * @property columns Configuration block for columns in the table. See `columns` below.
 * @property compressed Whether the data in the table is compressed.
 * @property inputFormat Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
 * @property location Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
 * @property numberOfBuckets Must be specified if the table contains any dimension columns.
 * @property outputFormat Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
 * @property parameters User-supplied properties in key-value form.
 * @property schemaReference Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
 * @property serDeInfo Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
 * @property skewedInfo Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
 * @property sortColumns Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
 * @property storedAsSubDirectories Whether the table data is stored in subdirectories.
 */
public data class CatalogTableStorageDescriptor(
    public val additionalLocations: List<String>? = null,
    public val bucketColumns: List<String>? = null,
    public val columns: List<CatalogTableStorageDescriptorColumn>? = null,
    public val compressed: Boolean? = null,
    public val inputFormat: String? = null,
    public val location: String? = null,
    public val numberOfBuckets: Int? = null,
    public val outputFormat: String? = null,
    public val parameters: Map<String, String>? = null,
    public val schemaReference: CatalogTableStorageDescriptorSchemaReference? = null,
    public val serDeInfo: CatalogTableStorageDescriptorSerDeInfo? = null,
    public val skewedInfo: CatalogTableStorageDescriptorSkewedInfo? = null,
    public val sortColumns: List<CatalogTableStorageDescriptorSortColumn>? = null,
    public val storedAsSubDirectories: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableStorageDescriptor): CatalogTableStorageDescriptor = CatalogTableStorageDescriptor(
            additionalLocations = javaType.additionalLocations().map({ args0 -> args0 }),
            bucketColumns = javaType.bucketColumns().map({ args0 -> args0 }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorColumn.Companion.toKotlin(args0)
                })
            }),
            compressed = javaType.compressed().map({ args0 -> args0 }).orElse(null),
            inputFormat = javaType.inputFormat().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            numberOfBuckets = javaType.numberOfBuckets().map({ args0 -> args0 }).orElse(null),
            outputFormat = javaType.outputFormat().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            schemaReference = javaType.schemaReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorSchemaReference.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serDeInfo = javaType.serDeInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorSerDeInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            skewedInfo = javaType.skewedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorSkewedInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sortColumns = javaType.sortColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorSortColumn.Companion.toKotlin(args0)
                })
            }),
            storedAsSubDirectories = javaType.storedAsSubDirectories().map({ args0 -> args0 }).orElse(null),
        )
    }
}
