@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property comment Free-form text comment.
 * @property name Name of the Column.
 * @property parameters Key-value pairs defining properties associated with the column.
 * @property type Datatype of data in the Column.
 */
public data class CatalogTableStorageDescriptorColumn(
    public val comment: String? = null,
    public val name: String,
    public val parameters: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableStorageDescriptorColumn): CatalogTableStorageDescriptorColumn = CatalogTableStorageDescriptorColumn(
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
