@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property column Name of the column.
 * @property sortOrder Whether the column is sorted in ascending (`1`) or descending order (`0`).
 */
public data class CatalogTableStorageDescriptorSortColumn(
    public val column: String,
    public val sortOrder: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableStorageDescriptorSortColumn): CatalogTableStorageDescriptorSortColumn = CatalogTableStorageDescriptorSortColumn(
            column = javaType.column(),
            sortOrder = javaType.sortOrder(),
        )
    }
}
