@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId ID of the Data Catalog in which the table resides.
 * @property databaseName Name of the catalog database that contains the target table.
 * @property name Name of the target table.
 * @property region Region of the target table.
 */
public data class CatalogTableTargetTable(
    public val catalogId: String,
    public val databaseName: String,
    public val name: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableTargetTable): CatalogTableTargetTable = CatalogTableTargetTable(
            catalogId = javaType.catalogId(),
            databaseName = javaType.databaseName(),
            name = javaType.name(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
