@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property classification An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
 * @property customPatterns Custom grok patterns used by this classifier.
 * @property grokPattern The grok pattern used by this classifier.
 */
public data class ClassifierGrokClassifier(
    public val classification: String,
    public val customPatterns: String? = null,
    public val grokPattern: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.ClassifierGrokClassifier): ClassifierGrokClassifier = ClassifierGrokClassifier(
            classification = javaType.classification(),
            customPatterns = javaType.customPatterns().map({ args0 -> args0 }).orElse(null),
            grokPattern = javaType.grokPattern(),
        )
    }
}
