@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property classification An identifier of the data format that the classifier matches.
 * @property rowTag The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
 */
public data class ClassifierXmlClassifier(
    public val classification: String,
    public val rowTag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.ClassifierXmlClassifier): ClassifierXmlClassifier = ClassifierXmlClassifier(
            classification = javaType.classification(),
            rowTag = javaType.rowTag(),
        )
    }
}
