@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
 * @property securityGroupIdLists The security group ID list used by the connection.
 * @property subnetId The subnet ID used by the connection.
 */
public data class ConnectionPhysicalConnectionRequirements(
    public val availabilityZone: String? = null,
    public val securityGroupIdLists: List<String>? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.ConnectionPhysicalConnectionRequirements): ConnectionPhysicalConnectionRequirements = ConnectionPhysicalConnectionRequirements(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            securityGroupIdLists = javaType.securityGroupIdLists().map({ args0 -> args0 }),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
