@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionName The name of the connection to use to connect to the Hudi target.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property maximumTraversalDepth The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time. Valid values are between `1` and `20`.
 * @property paths One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
 */
public data class CrawlerHudiTarget(
    public val connectionName: String? = null,
    public val exclusions: List<String>? = null,
    public val maximumTraversalDepth: Int,
    public val paths: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerHudiTarget): CrawlerHudiTarget = CrawlerHudiTarget(
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            exclusions = javaType.exclusions().map({ args0 -> args0 }),
            maximumTraversalDepth = javaType.maximumTraversalDepth(),
            paths = javaType.paths().map({ args0 -> args0 }),
        )
    }
}
