@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionName The name of the connection to use to connect to the JDBC target.
 * @property enableAdditionalMetadatas Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property path The path of the JDBC target.
 */
public data class CrawlerJdbcTarget(
    public val connectionName: String,
    public val enableAdditionalMetadatas: List<String>? = null,
    public val exclusions: List<String>? = null,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerJdbcTarget): CrawlerJdbcTarget = CrawlerJdbcTarget(
            connectionName = javaType.connectionName(),
            enableAdditionalMetadatas = javaType.enableAdditionalMetadatas().map({ args0 -> args0 }),
            exclusions = javaType.exclusions().map({ args0 -> args0 }),
            path = javaType.path(),
        )
    }
}
