@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property recrawlBehavior Specifies whether to crawl the entire dataset again, crawl only folders that were added since the last crawler run, or crawl what S3 notifies the crawler of via SQS. Valid Values are: `CRAWL_EVENT_MODE`, `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
 */
public data class CrawlerRecrawlPolicy(
    public val recrawlBehavior: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerRecrawlPolicy): CrawlerRecrawlPolicy = CrawlerRecrawlPolicy(
            recrawlBehavior = javaType.recrawlBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
