@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteBehavior The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
 * @property updateBehavior The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
 */
public data class CrawlerSchemaChangePolicy(
    public val deleteBehavior: String? = null,
    public val updateBehavior: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerSchemaChangePolicy): CrawlerSchemaChangePolicy = CrawlerSchemaChangePolicy(
            deleteBehavior = javaType.deleteBehavior().map({ args0 -> args0 }).orElse(null),
            updateBehavior = javaType.updateBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
