@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property connectionPasswordEncryption When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
 * @property encryptionAtRest Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
 */
public data class DataCatalogEncryptionSettingsDataCatalogEncryptionSettings(
    public val connectionPasswordEncryption: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption,
    public val encryptionAtRest: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettings): DataCatalogEncryptionSettingsDataCatalogEncryptionSettings =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettings(
                connectionPasswordEncryption = javaType.connectionPasswordEncryption().let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption.Companion.toKotlin(args0)
                }),
                encryptionAtRest = javaType.encryptionAtRest().let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest.Companion.toKotlin(args0)
                }),
            )
    }
}
