@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogEncryptionMode The encryption-at-rest mode for encrypting Data Catalog data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-KMS-WITH-SERVICE-ROLE`.
 * @property catalogEncryptionServiceRole The ARN of the AWS IAM role used for accessing encrypted Data Catalog data.
 * @property sseAwsKmsKeyId The ARN of the AWS KMS key to use for encryption at rest.
 */
public data class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest(
    public val catalogEncryptionMode: String,
    public val catalogEncryptionServiceRole: String? = null,
    public val sseAwsKmsKeyId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest): DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest(
                catalogEncryptionMode = javaType.catalogEncryptionMode(),
                catalogEncryptionServiceRole = javaType.catalogEncryptionServiceRole().map({ args0 ->
                    args0
                }).orElse(null),
                sseAwsKmsKeyId = javaType.sseAwsKmsKeyId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
