@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Free-form text comment.
 * @property name Name of the table.
 * @property type Datatype of data in the Column.
 */
public data class GetCatalogTablePartitionKey(
    public val comment: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTablePartitionKey): GetCatalogTablePartitionKey = GetCatalogTablePartitionKey(
            comment = javaType.comment(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
