@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property comment Free-form text comment.
 * @property name Name of the table.
 * @property parameters Map of initialization parameters for the SerDe, in key-value form.
 * @property type Datatype of data in the Column.
 */
public data class GetCatalogTableStorageDescriptorColumn(
    public val comment: String,
    public val name: String,
    public val parameters: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableStorageDescriptorColumn): GetCatalogTableStorageDescriptorColumn = GetCatalogTableStorageDescriptorColumn(
            comment = javaType.comment(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
