@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property name Name of the table.
 * @property parameters Map of initialization parameters for the SerDe, in key-value form.
 * @property serializationLibrary Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
 */
public data class GetCatalogTableStorageDescriptorSerDeInfo(
    public val name: String,
    public val parameters: Map<String, String>,
    public val serializationLibrary: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetCatalogTableStorageDescriptorSerDeInfo): GetCatalogTableStorageDescriptorSerDeInfo = GetCatalogTableStorageDescriptorSerDeInfo(
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serializationLibrary = javaType.serializationLibrary(),
        )
    }
}
