@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionPasswordEncryptions When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
 * @property encryptionAtRests Encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
 */
public data class GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting(
    public val connectionPasswordEncryptions: List<GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption>,
    public val encryptionAtRests: List<GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRest>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting): GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting =
            GetDataCatalogEncryptionSettingsDataCatalogEncryptionSetting(
                connectionPasswordEncryptions = javaType.connectionPasswordEncryptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption.Companion.toKotlin(args0)
                    })
                }),
                encryptionAtRests = javaType.encryptionAtRests().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingEncryptionAtRest.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
