@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsKmsKeyId KMS key ARN that is used to encrypt the connection password.
 * @property returnConnectionPasswordEncrypted When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
 */
public data class
GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption(
    public val awsKmsKeyId: String,
    public val returnConnectionPasswordEncrypted: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption): GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption =
            GetDataCatalogEncryptionSettingsDataCatalogEncryptionSettingConnectionPasswordEncryption(
                awsKmsKeyId = javaType.awsKmsKeyId(),
                returnConnectionPasswordEncrypted = javaType.returnConnectionPasswordEncrypted(),
            )
    }
}
