@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property source ID of the node at which the edge starts.
 * @property target ID of the node at which the edge ends.
 * @property targetParameter Target of the edge.
 */
public data class GetScriptDagEdge(
    public val source: String,
    public val target: String,
    public val targetParameter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetScriptDagEdge): GetScriptDagEdge =
            GetScriptDagEdge(
                source = javaType.source(),
                target = javaType.target(),
                targetParameter = javaType.targetParameter().map({ args0 -> args0 }).orElse(null),
            )
    }
}
