@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the argument or property.
 * @property param Boolean if the value is used as a parameter. Defaults to `false`.
 * @property value Value of the argument or property.
 */
public data class GetScriptDagNodeArg(
    public val name: String,
    public val `param`: Boolean? = null,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetScriptDagNodeArg): GetScriptDagNodeArg = GetScriptDagNodeArg(
            name = javaType.name(),
            `param` = javaType.`param`().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
