@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getScript.
 * @property dagEdges
 * @property dagNodes
 * @property id The provider-assigned unique ID for this managed resource.
 * @property language
 * @property pythonScript Python script generated from the DAG when the `language` argument is set to `PYTHON`.
 * @property scalaCode Scala code generated from the DAG when the `language` argument is set to `SCALA`.
 */
public data class GetScriptResult(
    public val dagEdges: List<GetScriptDagEdge>,
    public val dagNodes: List<GetScriptDagNode>,
    public val id: String,
    public val language: String? = null,
    public val pythonScript: String,
    public val scalaCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.GetScriptResult): GetScriptResult =
            GetScriptResult(
                dagEdges = javaType.dagEdges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetScriptDagEdge.Companion.toKotlin(args0)
                    })
                }),
                dagNodes = javaType.dagNodes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.GetScriptDagNode.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                language = javaType.language().map({ args0 -> args0 }).orElse(null),
                pythonScript = javaType.pythonScript(),
                scalaCode = javaType.scalaCode(),
            )
    }
}
