@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, `glueray` for Ray Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
 * @property pythonVersion The Python version being used to execute a Python shell job. Allowed values are 2, 3 or 3.9. Version 3 refers to Python 3.6.
 * @property runtime In Ray jobs, runtime is used to specify the versions of Ray, Python and additional libraries available in your environment. This field is not used in other job types. For supported runtime environment values, see [Working with Ray jobs](https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html#author-job-ray-runtimes) in the Glue Developer Guide.
 * @property scriptLocation Specifies the S3 path to a script that executes a job.
 */
public data class JobCommand(
    public val name: String? = null,
    public val pythonVersion: String? = null,
    public val runtime: String? = null,
    public val scriptLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.JobCommand): JobCommand = JobCommand(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            pythonVersion = javaType.pythonVersion().map({ args0 -> args0 }).orElse(null),
            runtime = javaType.runtime().map({ args0 -> args0 }).orElse(null),
            scriptLocation = javaType.scriptLocation(),
        )
    }
}
