@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property findMatchesParameters The parameters for the find matches algorithm. see Find Matches Parameters.
 * @property transformType The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
 */
public data class MLTransformParameters(
    public val findMatchesParameters: MLTransformParametersFindMatchesParameters,
    public val transformType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.MLTransformParameters): MLTransformParameters = MLTransformParameters(
            findMatchesParameters = javaType.findMatchesParameters().let({ args0 ->
                com.pulumi.aws.glue.kotlin.outputs.MLTransformParametersFindMatchesParameters.Companion.toKotlin(args0)
            }),
            transformType = javaType.transformType(),
        )
    }
}
