@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataType The type of data in the column.
 * @property name The name you assign to this ML Transform. It must be unique in your account.
 */
public data class MLTransformSchema(
    public val dataType: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.MLTransformSchema): MLTransformSchema = MLTransformSchema(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
