@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchEncryptionMode Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 */
public data class SecurityConfigurationEncryptionConfigurationCloudwatchEncryption(
    public val cloudwatchEncryptionMode: String? = null,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryption): SecurityConfigurationEncryptionConfigurationCloudwatchEncryption =
            SecurityConfigurationEncryptionConfigurationCloudwatchEncryption(
                cloudwatchEncryptionMode = javaType.cloudwatchEncryptionMode().map({ args0 -> args0 }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
