@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 * @property s3EncryptionMode Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
 */
public data class SecurityConfigurationEncryptionConfigurationS3Encryption(
    public val kmsKeyArn: String? = null,
    public val s3EncryptionMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.SecurityConfigurationEncryptionConfigurationS3Encryption): SecurityConfigurationEncryptionConfigurationS3Encryption =
            SecurityConfigurationEncryptionConfigurationS3Encryption(
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
                s3EncryptionMode = javaType.s3EncryptionMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
