@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property arguments Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
 * @property crawlerName The name of the crawler to be executed. Conflicts with `job_name`.
 * @property jobName The name of a job to be executed. Conflicts with `crawler_name`.
 * @property notificationProperty Specifies configuration properties of a job run notification. See Notification Property details below.
 * @property securityConfiguration The name of the Security Configuration structure to be used with this action.
 * @property timeout The job run timeout in minutes. It overrides the timeout value of the job.
 */
public data class TriggerAction(
    public val arguments: Map<String, String>? = null,
    public val crawlerName: String? = null,
    public val jobName: String? = null,
    public val notificationProperty: TriggerActionNotificationProperty? = null,
    public val securityConfiguration: String? = null,
    public val timeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.TriggerAction): TriggerAction =
            TriggerAction(
                arguments = javaType.arguments().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                crawlerName = javaType.crawlerName().map({ args0 -> args0 }).orElse(null),
                jobName = javaType.jobName().map({ args0 -> args0 }).orElse(null),
                notificationProperty = javaType.notificationProperty().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.TriggerActionNotificationProperty.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                securityConfiguration = javaType.securityConfiguration().map({ args0 -> args0 }).orElse(null),
                timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            )
    }
}
