@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property batchSize Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
 * @property batchWindow Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
 */
public data class TriggerEventBatchingCondition(
    public val batchSize: Int,
    public val batchWindow: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.TriggerEventBatchingCondition): TriggerEventBatchingCondition = TriggerEventBatchingCondition(
            batchSize = javaType.batchSize(),
            batchWindow = javaType.batchWindow().map({ args0 -> args0 }).orElse(null),
        )
    }
}
