@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property conditions A list of the conditions that determine when the trigger will fire. See Conditions.
 * @property logical How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
 */
public data class TriggerPredicate(
    public val conditions: List<TriggerPredicateCondition>,
    public val logical: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.TriggerPredicate): TriggerPredicate =
            TriggerPredicate(
                conditions = javaType.conditions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.glue.kotlin.outputs.TriggerPredicateCondition.Companion.toKotlin(args0)
                    })
                }),
                logical = javaType.logical().map({ args0 -> args0 }).orElse(null),
            )
    }
}
