@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceType The type of the resource. can be one of `JAR`, `FILE`, and `ARCHIVE`.
 * @property uri The URI for accessing the resource.
 */
public data class UserDefinedFunctionResourceUri(
    public val resourceType: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.UserDefinedFunctionResourceUri): UserDefinedFunctionResourceUri = UserDefinedFunctionResourceUri(
            resourceType = javaType.resourceType(),
            uri = javaType.uri(),
        )
    }
}
