@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.GrafanaFunctions.getWorkspacePlain
import com.pulumi.aws.grafana.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.aws.grafana.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.aws.grafana.kotlin.outputs.GetWorkspaceResult
import com.pulumi.aws.grafana.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object GrafanaFunctions {
    /**
     * Provides an Amazon Managed Grafana workspace data source.
     * ## Example Usage
     * ### Basic configuration
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.grafana.getWorkspace({
     *     workspaceId: "g-2054c75a02",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.grafana.get_workspace(workspace_id="g-2054c75a02")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Grafana.GetWorkspace.Invoke(new()
     *     {
     *         WorkspaceId = "g-2054c75a02",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := grafana.LookupWorkspace(ctx, &grafana.LookupWorkspaceArgs{
     * 			WorkspaceId: "g-2054c75a02",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.grafana.GrafanaFunctions;
     * import com.pulumi.aws.grafana.inputs.GetWorkspaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GrafanaFunctions.getWorkspace(GetWorkspaceArgs.builder()
     *             .workspaceId("g-2054c75a02")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:grafana:getWorkspace
     *       Arguments:
     *         workspaceId: g-2054c75a02
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWorkspace.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        toKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param tags Tags assigned to the resource
     * @param workspaceId Grafana workspace ID.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(tags: Map<String, String>? = null, workspaceId: String): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            tags = tags,
            workspaceId = workspaceId,
        )
        return toKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;grafana&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit): GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
