@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoleAssociation].
 */
@PulumiTagMarker
public class RoleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssociationArgs = RoleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssociationArgsBuilder.() -> Unit) {
        val builder = RoleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RoleAssociation {
        val builtJavaResource = com.pulumi.aws.grafana.RoleAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoleAssociation(builtJavaResource)
    }
}

/**
 * Provides an Amazon Managed Grafana workspace role association resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assume = new aws.iam.Role("assume", {
 *     name: "grafana-assume",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "grafana.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleWorkspace = new aws.grafana.Workspace("example", {
 *     accountAccessType: "CURRENT_ACCOUNT",
 *     authenticationProviders: ["SAML"],
 *     permissionType: "SERVICE_MANAGED",
 *     roleArn: assume.arn,
 * });
 * const example = new aws.grafana.RoleAssociation("example", {
 *     role: "ADMIN",
 *     userIds: [
 *         "USER_ID_1",
 *         "USER_ID_2",
 *     ],
 *     workspaceId: exampleWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * assume = aws.iam.Role("assume",
 *     name="grafana-assume",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "grafana.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_workspace = aws.grafana.Workspace("example",
 *     account_access_type="CURRENT_ACCOUNT",
 *     authentication_providers=["SAML"],
 *     permission_type="SERVICE_MANAGED",
 *     role_arn=assume.arn)
 * example = aws.grafana.RoleAssociation("example",
 *     role="ADMIN",
 *     user_ids=[
 *         "USER_ID_1",
 *         "USER_ID_2",
 *     ],
 *     workspace_id=example_workspace.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assume = new Aws.Iam.Role("assume", new()
 *     {
 *         Name = "grafana-assume",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "grafana.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleWorkspace = new Aws.Grafana.Workspace("example", new()
 *     {
 *         AccountAccessType = "CURRENT_ACCOUNT",
 *         AuthenticationProviders = new[]
 *         {
 *             "SAML",
 *         },
 *         PermissionType = "SERVICE_MANAGED",
 *         RoleArn = assume.Arn,
 *     });
 *     var example = new Aws.Grafana.RoleAssociation("example", new()
 *     {
 *         Role = "ADMIN",
 *         UserIds = new[]
 *         {
 *             "USER_ID_1",
 *             "USER_ID_2",
 *         },
 *         WorkspaceId = exampleWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "grafana.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		assume, err := iam.NewRole(ctx, "assume", &iam.RoleArgs{
 * 			Name:             pulumi.String("grafana-assume"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleWorkspace, err := grafana.NewWorkspace(ctx, "example", &grafana.WorkspaceArgs{
 * 			AccountAccessType: pulumi.String("CURRENT_ACCOUNT"),
 * 			AuthenticationProviders: pulumi.StringArray{
 * 				pulumi.String("SAML"),
 * 			},
 * 			PermissionType: pulumi.String("SERVICE_MANAGED"),
 * 			RoleArn:        assume.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewRoleAssociation(ctx, "example", &grafana.RoleAssociationArgs{
 * 			Role: pulumi.String("ADMIN"),
 * 			UserIds: pulumi.StringArray{
 * 				pulumi.String("USER_ID_1"),
 * 				pulumi.String("USER_ID_2"),
 * 			},
 * 			WorkspaceId: exampleWorkspace.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.RoleAssociation;
 * import com.pulumi.aws.grafana.RoleAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .name("grafana-assume")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var example = new RoleAssociation("example", RoleAssociationArgs.builder()
 *             .role("ADMIN")
 *             .userIds(
 *                 "USER_ID_1",
 *                 "USER_ID_2")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:RoleAssociation
 *     properties:
 *       role: ADMIN
 *       userIds:
 *         - USER_ID_1
 *         - USER_ID_2
 *       workspaceId: ${exampleWorkspace.id}
 *   exampleWorkspace:
 *     type: aws:grafana:Workspace
 *     name: example
 *     properties:
 *       accountAccessType: CURRENT_ACCOUNT
 *       authenticationProviders:
 *         - SAML
 *       permissionType: SERVICE_MANAGED
 *       roleArn: ${assume.arn}
 *   assume:
 *     type: aws:iam:Role
 *     properties:
 *       name: grafana-assume
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: grafana.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class RoleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.grafana.RoleAssociation,
) : KotlinCustomResource(javaResource, RoleAssociationMapper) {
    /**
     * The AWS SSO group ids to be assigned the role given in `role`.
     */
    public val groupIds: Output<List<String>>?
        get() = javaResource.groupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The AWS SSO user ids to be assigned the role given in `role`.
     */
    public val userIds: Output<List<String>>?
        get() = javaResource.userIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The workspace id.
     * The following arguments are optional:
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object RoleAssociationMapper : ResourceMapper<RoleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.RoleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssociation = RoleAssociation(
        javaResource as
            com.pulumi.aws.grafana.RoleAssociation,
    )
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssociation].
 */
public suspend fun roleAssociation(
    name: String,
    block: suspend RoleAssociationResourceBuilder.() -> Unit,
): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssociation(name: String): RoleAssociation {
    val builder = RoleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
