@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.RoleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace role association resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assume = new aws.iam.Role("assume", {
 *     name: "grafana-assume",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "grafana.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleWorkspace = new aws.grafana.Workspace("example", {
 *     accountAccessType: "CURRENT_ACCOUNT",
 *     authenticationProviders: ["SAML"],
 *     permissionType: "SERVICE_MANAGED",
 *     roleArn: assume.arn,
 * });
 * const example = new aws.grafana.RoleAssociation("example", {
 *     role: "ADMIN",
 *     userIds: [
 *         "USER_ID_1",
 *         "USER_ID_2",
 *     ],
 *     workspaceId: exampleWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * assume = aws.iam.Role("assume",
 *     name="grafana-assume",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "grafana.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_workspace = aws.grafana.Workspace("example",
 *     account_access_type="CURRENT_ACCOUNT",
 *     authentication_providers=["SAML"],
 *     permission_type="SERVICE_MANAGED",
 *     role_arn=assume.arn)
 * example = aws.grafana.RoleAssociation("example",
 *     role="ADMIN",
 *     user_ids=[
 *         "USER_ID_1",
 *         "USER_ID_2",
 *     ],
 *     workspace_id=example_workspace.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assume = new Aws.Iam.Role("assume", new()
 *     {
 *         Name = "grafana-assume",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "grafana.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleWorkspace = new Aws.Grafana.Workspace("example", new()
 *     {
 *         AccountAccessType = "CURRENT_ACCOUNT",
 *         AuthenticationProviders = new[]
 *         {
 *             "SAML",
 *         },
 *         PermissionType = "SERVICE_MANAGED",
 *         RoleArn = assume.Arn,
 *     });
 *     var example = new Aws.Grafana.RoleAssociation("example", new()
 *     {
 *         Role = "ADMIN",
 *         UserIds = new[]
 *         {
 *             "USER_ID_1",
 *             "USER_ID_2",
 *         },
 *         WorkspaceId = exampleWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "grafana.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		assume, err := iam.NewRole(ctx, "assume", &iam.RoleArgs{
 * 			Name:             pulumi.String("grafana-assume"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleWorkspace, err := grafana.NewWorkspace(ctx, "example", &grafana.WorkspaceArgs{
 * 			AccountAccessType: pulumi.String("CURRENT_ACCOUNT"),
 * 			AuthenticationProviders: pulumi.StringArray{
 * 				pulumi.String("SAML"),
 * 			},
 * 			PermissionType: pulumi.String("SERVICE_MANAGED"),
 * 			RoleArn:        assume.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewRoleAssociation(ctx, "example", &grafana.RoleAssociationArgs{
 * 			Role: pulumi.String("ADMIN"),
 * 			UserIds: pulumi.StringArray{
 * 				pulumi.String("USER_ID_1"),
 * 				pulumi.String("USER_ID_2"),
 * 			},
 * 			WorkspaceId: exampleWorkspace.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.RoleAssociation;
 * import com.pulumi.aws.grafana.RoleAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .name("grafana-assume")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var example = new RoleAssociation("example", RoleAssociationArgs.builder()
 *             .role("ADMIN")
 *             .userIds(
 *                 "USER_ID_1",
 *                 "USER_ID_2")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:RoleAssociation
 *     properties:
 *       role: ADMIN
 *       userIds:
 *         - USER_ID_1
 *         - USER_ID_2
 *       workspaceId: ${exampleWorkspace.id}
 *   exampleWorkspace:
 *     type: aws:grafana:Workspace
 *     name: example
 *     properties:
 *       accountAccessType: CURRENT_ACCOUNT
 *       authenticationProviders:
 *         - SAML
 *       permissionType: SERVICE_MANAGED
 *       roleArn: ${assume.arn}
 *   assume:
 *     type: aws:iam:Role
 *     properties:
 *       name: grafana-assume
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: grafana.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * @property groupIds The AWS SSO group ids to be assigned the role given in `role`.
 * @property role The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
 * @property userIds The AWS SSO user ids to be assigned the role given in `role`.
 * @property workspaceId The workspace id.
 * The following arguments are optional:
 */
public data class RoleAssociationArgs(
    public val groupIds: Output<List<String>>? = null,
    public val role: Output<String>? = null,
    public val userIds: Output<List<String>>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.RoleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.RoleAssociationArgs =
        com.pulumi.aws.grafana.RoleAssociationArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .role(role?.applyValue({ args0 -> args0 }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAssociationArgs].
 */
@PulumiTagMarker
public class RoleAssociationArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var role: Output<String>? = null

    private var userIds: Output<List<String>>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("gkiqbyfoarfbrked")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("ontaxumqaytuasch")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("ubijubdgeiilfcxl")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    @JvmName("btlsspfrywvqgxoe")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("fbsyswtqqqhttxos")
    public suspend fun userIds(`value`: Output<List<String>>) {
        this.userIds = value
    }

    @JvmName("eplevtbsysppcsji")
    public suspend fun userIds(vararg values: Output<String>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("weyryorsodqodgnn")
    public suspend fun userIds(values: List<Output<String>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("lpddorolwdxyfwfg")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("tnltyqeefrrfpisn")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The AWS SSO group ids to be assigned the role given in `role`.
     */
    @JvmName("ydhhwelnnlnikoep")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The grafana role. Valid values can be found [here](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateInstruction.html#ManagedGrafana-Type-UpdateInstruction-role).
     */
    @JvmName("gpxwpkykuoccpipr")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("lnndwfgmykopjbfs")
    public suspend fun userIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values The AWS SSO user ids to be assigned the role given in `role`.
     */
    @JvmName("xurtybrgkttbgjpf")
    public suspend fun userIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("pyohidrvsinvqysn")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): RoleAssociationArgs = RoleAssociationArgs(
        groupIds = groupIds,
        role = role,
        userIds = userIds,
        workspaceId = workspaceId,
    )
}
