@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceApiKey].
 */
@PulumiTagMarker
public class WorkspaceApiKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceApiKeyArgs = WorkspaceApiKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceApiKeyArgsBuilder.() -> Unit) {
        val builder = WorkspaceApiKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceApiKey {
        val builtJavaResource = com.pulumi.aws.grafana.WorkspaceApiKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkspaceApiKey(builtJavaResource)
    }
}

/**
 * Provides an Amazon Managed Grafana workspace API Key resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const key = new aws.grafana.WorkspaceApiKey("key", {
 *     keyName: "test-key",
 *     keyRole: "VIEWER",
 *     secondsToLive: 3600,
 *     workspaceId: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * key = aws.grafana.WorkspaceApiKey("key",
 *     key_name="test-key",
 *     key_role="VIEWER",
 *     seconds_to_live=3600,
 *     workspace_id=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new Aws.Grafana.WorkspaceApiKey("key", new()
 *     {
 *         KeyName = "test-key",
 *         KeyRole = "VIEWER",
 *         SecondsToLive = 3600,
 *         WorkspaceId = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := grafana.NewWorkspaceApiKey(ctx, "key", &grafana.WorkspaceApiKeyArgs{
 * 			KeyName:       pulumi.String("test-key"),
 * 			KeyRole:       pulumi.String("VIEWER"),
 * 			SecondsToLive: pulumi.Int(3600),
 * 			WorkspaceId:   pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceApiKey;
 * import com.pulumi.aws.grafana.WorkspaceApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new WorkspaceApiKey("key", WorkspaceApiKeyArgs.builder()
 *             .keyName("test-key")
 *             .keyRole("VIEWER")
 *             .secondsToLive(3600)
 *             .workspaceId(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   key:
 *     type: aws:grafana:WorkspaceApiKey
 *     properties:
 *       keyName: test-key
 *       keyRole: VIEWER
 *       secondsToLive: 3600
 *       workspaceId: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class WorkspaceApiKey internal constructor(
    override val javaResource: com.pulumi.aws.grafana.WorkspaceApiKey,
) : KotlinCustomResource(javaResource, WorkspaceApiKeyMapper) {
    /**
     * The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the API key. Key names must be unique to the workspace.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
     */
    public val keyRole: Output<String>
        get() = javaResource.keyRole().applyValue({ args0 -> args0 })

    /**
     * Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
     */
    public val secondsToLive: Output<Int>
        get() = javaResource.secondsToLive().applyValue({ args0 -> args0 })

    /**
     * The ID of the workspace that the API key is valid for.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceApiKeyMapper : ResourceMapper<WorkspaceApiKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.WorkspaceApiKey::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceApiKey = WorkspaceApiKey(
        javaResource as
            com.pulumi.aws.grafana.WorkspaceApiKey,
    )
}

/**
 * @see [WorkspaceApiKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceApiKey].
 */
public suspend fun workspaceApiKey(
    name: String,
    block: suspend WorkspaceApiKeyResourceBuilder.() -> Unit,
): WorkspaceApiKey {
    val builder = WorkspaceApiKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceApiKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceApiKey(name: String): WorkspaceApiKey {
    val builder = WorkspaceApiKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
