@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WorkspaceSamlConfiguration].
 */
@PulumiTagMarker
public class WorkspaceSamlConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceSamlConfigurationArgs = WorkspaceSamlConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceSamlConfigurationArgsBuilder.() -> Unit) {
        val builder = WorkspaceSamlConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceSamlConfiguration {
        val builtJavaResource =
            com.pulumi.aws.grafana.WorkspaceSamlConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceSamlConfiguration(builtJavaResource)
    }
}

/**
 * Provides an Amazon Managed Grafana workspace SAML configuration resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assume = new aws.iam.Role("assume", {
 *     name: "grafana-assume",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "grafana.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleWorkspace = new aws.grafana.Workspace("example", {
 *     accountAccessType: "CURRENT_ACCOUNT",
 *     authenticationProviders: ["SAML"],
 *     permissionType: "SERVICE_MANAGED",
 *     roleArn: assume.arn,
 * });
 * const example = new aws.grafana.WorkspaceSamlConfiguration("example", {
 *     editorRoleValues: ["editor"],
 *     idpMetadataUrl: "https://my_idp_metadata.url",
 *     workspaceId: exampleWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * assume = aws.iam.Role("assume",
 *     name="grafana-assume",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "grafana.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_workspace = aws.grafana.Workspace("example",
 *     account_access_type="CURRENT_ACCOUNT",
 *     authentication_providers=["SAML"],
 *     permission_type="SERVICE_MANAGED",
 *     role_arn=assume.arn)
 * example = aws.grafana.WorkspaceSamlConfiguration("example",
 *     editor_role_values=["editor"],
 *     idp_metadata_url="https://my_idp_metadata.url",
 *     workspace_id=example_workspace.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assume = new Aws.Iam.Role("assume", new()
 *     {
 *         Name = "grafana-assume",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "grafana.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleWorkspace = new Aws.Grafana.Workspace("example", new()
 *     {
 *         AccountAccessType = "CURRENT_ACCOUNT",
 *         AuthenticationProviders = new[]
 *         {
 *             "SAML",
 *         },
 *         PermissionType = "SERVICE_MANAGED",
 *         RoleArn = assume.Arn,
 *     });
 *     var example = new Aws.Grafana.WorkspaceSamlConfiguration("example", new()
 *     {
 *         EditorRoleValues = new[]
 *         {
 *             "editor",
 *         },
 *         IdpMetadataUrl = "https://my_idp_metadata.url",
 *         WorkspaceId = exampleWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "grafana.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		assume, err := iam.NewRole(ctx, "assume", &iam.RoleArgs{
 * 			Name:             pulumi.String("grafana-assume"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleWorkspace, err := grafana.NewWorkspace(ctx, "example", &grafana.WorkspaceArgs{
 * 			AccountAccessType: pulumi.String("CURRENT_ACCOUNT"),
 * 			AuthenticationProviders: pulumi.StringArray{
 * 				pulumi.String("SAML"),
 * 			},
 * 			PermissionType: pulumi.String("SERVICE_MANAGED"),
 * 			RoleArn:        assume.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewWorkspaceSamlConfiguration(ctx, "example", &grafana.WorkspaceSamlConfigurationArgs{
 * 			EditorRoleValues: pulumi.StringArray{
 * 				pulumi.String("editor"),
 * 			},
 * 			IdpMetadataUrl: pulumi.String("https://my_idp_metadata.url"),
 * 			WorkspaceId:    exampleWorkspace.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfiguration;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .name("grafana-assume")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var example = new WorkspaceSamlConfiguration("example", WorkspaceSamlConfigurationArgs.builder()
 *             .editorRoleValues("editor")
 *             .idpMetadataUrl("https://my_idp_metadata.url")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceSamlConfiguration
 *     properties:
 *       editorRoleValues:
 *         - editor
 *       idpMetadataUrl: https://my_idp_metadata.url
 *       workspaceId: ${exampleWorkspace.id}
 *   exampleWorkspace:
 *     type: aws:grafana:Workspace
 *     name: example
 *     properties:
 *       accountAccessType: CURRENT_ACCOUNT
 *       authenticationProviders:
 *         - SAML
 *       permissionType: SERVICE_MANAGED
 *       roleArn: ${assume.arn}
 *   assume:
 *     type: aws:iam:Role
 *     properties:
 *       name: grafana-assume
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: grafana.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Grafana Workspace SAML configuration using the workspace's `id`. For example:
 * ```sh
 * $ pulumi import aws:grafana/workspaceSamlConfiguration:WorkspaceSamlConfiguration example g-2054c75a02
 * ```
 */
public class WorkspaceSamlConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.grafana.WorkspaceSamlConfiguration,
) : KotlinCustomResource(javaResource, WorkspaceSamlConfigurationMapper) {
    /**
     * The admin role values.
     */
    public val adminRoleValues: Output<List<String>>?
        get() = javaResource.adminRoleValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The allowed organizations.
     */
    public val allowedOrganizations: Output<List<String>>?
        get() = javaResource.allowedOrganizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The editor role values.
     */
    public val editorRoleValues: Output<List<String>>
        get() = javaResource.editorRoleValues().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The email assertion.
     */
    public val emailAssertion: Output<String>
        get() = javaResource.emailAssertion().applyValue({ args0 -> args0 })

    /**
     * The groups assertion.
     */
    public val groupsAssertion: Output<String>?
        get() = javaResource.groupsAssertion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    public val idpMetadataUrl: Output<String>?
        get() = javaResource.idpMetadataUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    public val idpMetadataXml: Output<String>?
        get() = javaResource.idpMetadataXml().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The login assertion.
     */
    public val loginAssertion: Output<String>
        get() = javaResource.loginAssertion().applyValue({ args0 -> args0 })

    /**
     * The login validity duration.
     */
    public val loginValidityDuration: Output<Int>
        get() = javaResource.loginValidityDuration().applyValue({ args0 -> args0 })

    /**
     * The name assertion.
     */
    public val nameAssertion: Output<String>
        get() = javaResource.nameAssertion().applyValue({ args0 -> args0 })

    /**
     * The org assertion.
     */
    public val orgAssertion: Output<String>?
        get() = javaResource.orgAssertion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role assertion.
     */
    public val roleAssertion: Output<String>?
        get() = javaResource.roleAssertion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the SAML configuration.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The workspace id.
     * The following arguments are optional:
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceSamlConfigurationMapper : ResourceMapper<WorkspaceSamlConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.WorkspaceSamlConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceSamlConfiguration =
        WorkspaceSamlConfiguration(javaResource as com.pulumi.aws.grafana.WorkspaceSamlConfiguration)
}

/**
 * @see [WorkspaceSamlConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceSamlConfiguration].
 */
public suspend fun workspaceSamlConfiguration(
    name: String,
    block: suspend WorkspaceSamlConfigurationResourceBuilder.() -> Unit,
): WorkspaceSamlConfiguration {
    val builder = WorkspaceSamlConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceSamlConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceSamlConfiguration(name: String): WorkspaceSamlConfiguration {
    val builder = WorkspaceSamlConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
