@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Managed Grafana workspace SAML configuration resource.
 * ## Example Usage
 * ### Basic configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assume = new aws.iam.Role("assume", {
 *     name: "grafana-assume",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "grafana.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleWorkspace = new aws.grafana.Workspace("example", {
 *     accountAccessType: "CURRENT_ACCOUNT",
 *     authenticationProviders: ["SAML"],
 *     permissionType: "SERVICE_MANAGED",
 *     roleArn: assume.arn,
 * });
 * const example = new aws.grafana.WorkspaceSamlConfiguration("example", {
 *     editorRoleValues: ["editor"],
 *     idpMetadataUrl: "https://my_idp_metadata.url",
 *     workspaceId: exampleWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * assume = aws.iam.Role("assume",
 *     name="grafana-assume",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "grafana.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_workspace = aws.grafana.Workspace("example",
 *     account_access_type="CURRENT_ACCOUNT",
 *     authentication_providers=["SAML"],
 *     permission_type="SERVICE_MANAGED",
 *     role_arn=assume.arn)
 * example = aws.grafana.WorkspaceSamlConfiguration("example",
 *     editor_role_values=["editor"],
 *     idp_metadata_url="https://my_idp_metadata.url",
 *     workspace_id=example_workspace.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assume = new Aws.Iam.Role("assume", new()
 *     {
 *         Name = "grafana-assume",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "grafana.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleWorkspace = new Aws.Grafana.Workspace("example", new()
 *     {
 *         AccountAccessType = "CURRENT_ACCOUNT",
 *         AuthenticationProviders = new[]
 *         {
 *             "SAML",
 *         },
 *         PermissionType = "SERVICE_MANAGED",
 *         RoleArn = assume.Arn,
 *     });
 *     var example = new Aws.Grafana.WorkspaceSamlConfiguration("example", new()
 *     {
 *         EditorRoleValues = new[]
 *         {
 *             "editor",
 *         },
 *         IdpMetadataUrl = "https://my_idp_metadata.url",
 *         WorkspaceId = exampleWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "grafana.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		assume, err := iam.NewRole(ctx, "assume", &iam.RoleArgs{
 * 			Name:             pulumi.String("grafana-assume"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleWorkspace, err := grafana.NewWorkspace(ctx, "example", &grafana.WorkspaceArgs{
 * 			AccountAccessType: pulumi.String("CURRENT_ACCOUNT"),
 * 			AuthenticationProviders: pulumi.StringArray{
 * 				pulumi.String("SAML"),
 * 			},
 * 			PermissionType: pulumi.String("SERVICE_MANAGED"),
 * 			RoleArn:        assume.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewWorkspaceSamlConfiguration(ctx, "example", &grafana.WorkspaceSamlConfigurationArgs{
 * 			EditorRoleValues: pulumi.StringArray{
 * 				pulumi.String("editor"),
 * 			},
 * 			IdpMetadataUrl: pulumi.String("https://my_idp_metadata.url"),
 * 			WorkspaceId:    exampleWorkspace.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.grafana.Workspace;
 * import com.pulumi.aws.grafana.WorkspaceArgs;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfiguration;
 * import com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assume = new Role("assume", RoleArgs.builder()
 *             .name("grafana-assume")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "grafana.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .accountAccessType("CURRENT_ACCOUNT")
 *             .authenticationProviders("SAML")
 *             .permissionType("SERVICE_MANAGED")
 *             .roleArn(assume.arn())
 *             .build());
 *         var example = new WorkspaceSamlConfiguration("example", WorkspaceSamlConfigurationArgs.builder()
 *             .editorRoleValues("editor")
 *             .idpMetadataUrl("https://my_idp_metadata.url")
 *             .workspaceId(exampleWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceSamlConfiguration
 *     properties:
 *       editorRoleValues:
 *         - editor
 *       idpMetadataUrl: https://my_idp_metadata.url
 *       workspaceId: ${exampleWorkspace.id}
 *   exampleWorkspace:
 *     type: aws:grafana:Workspace
 *     name: example
 *     properties:
 *       accountAccessType: CURRENT_ACCOUNT
 *       authenticationProviders:
 *         - SAML
 *       permissionType: SERVICE_MANAGED
 *       roleArn: ${assume.arn}
 *   assume:
 *     type: aws:iam:Role
 *     properties:
 *       name: grafana-assume
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: grafana.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Grafana Workspace SAML configuration using the workspace's `id`. For example:
 * ```sh
 * $ pulumi import aws:grafana/workspaceSamlConfiguration:WorkspaceSamlConfiguration example g-2054c75a02
 * ```
 * @property adminRoleValues The admin role values.
 * @property allowedOrganizations The allowed organizations.
 * @property editorRoleValues The editor role values.
 * @property emailAssertion The email assertion.
 * @property groupsAssertion The groups assertion.
 * @property idpMetadataUrl The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
 * @property idpMetadataXml The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
 * @property loginAssertion The login assertion.
 * @property loginValidityDuration The login validity duration.
 * @property nameAssertion The name assertion.
 * @property orgAssertion The org assertion.
 * @property roleAssertion The role assertion.
 * @property workspaceId The workspace id.
 * The following arguments are optional:
 */
public data class WorkspaceSamlConfigurationArgs(
    public val adminRoleValues: Output<List<String>>? = null,
    public val allowedOrganizations: Output<List<String>>? = null,
    public val editorRoleValues: Output<List<String>>? = null,
    public val emailAssertion: Output<String>? = null,
    public val groupsAssertion: Output<String>? = null,
    public val idpMetadataUrl: Output<String>? = null,
    public val idpMetadataXml: Output<String>? = null,
    public val loginAssertion: Output<String>? = null,
    public val loginValidityDuration: Output<Int>? = null,
    public val nameAssertion: Output<String>? = null,
    public val orgAssertion: Output<String>? = null,
    public val roleAssertion: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs =
        com.pulumi.aws.grafana.WorkspaceSamlConfigurationArgs.builder()
            .adminRoleValues(adminRoleValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrganizations(allowedOrganizations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .editorRoleValues(editorRoleValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .emailAssertion(emailAssertion?.applyValue({ args0 -> args0 }))
            .groupsAssertion(groupsAssertion?.applyValue({ args0 -> args0 }))
            .idpMetadataUrl(idpMetadataUrl?.applyValue({ args0 -> args0 }))
            .idpMetadataXml(idpMetadataXml?.applyValue({ args0 -> args0 }))
            .loginAssertion(loginAssertion?.applyValue({ args0 -> args0 }))
            .loginValidityDuration(loginValidityDuration?.applyValue({ args0 -> args0 }))
            .nameAssertion(nameAssertion?.applyValue({ args0 -> args0 }))
            .orgAssertion(orgAssertion?.applyValue({ args0 -> args0 }))
            .roleAssertion(roleAssertion?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceSamlConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceSamlConfigurationArgsBuilder internal constructor() {
    private var adminRoleValues: Output<List<String>>? = null

    private var allowedOrganizations: Output<List<String>>? = null

    private var editorRoleValues: Output<List<String>>? = null

    private var emailAssertion: Output<String>? = null

    private var groupsAssertion: Output<String>? = null

    private var idpMetadataUrl: Output<String>? = null

    private var idpMetadataXml: Output<String>? = null

    private var loginAssertion: Output<String>? = null

    private var loginValidityDuration: Output<Int>? = null

    private var nameAssertion: Output<String>? = null

    private var orgAssertion: Output<String>? = null

    private var roleAssertion: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The admin role values.
     */
    @JvmName("nstjogvortwiruwa")
    public suspend fun adminRoleValues(`value`: Output<List<String>>) {
        this.adminRoleValues = value
    }

    @JvmName("fdrocfelmoxovfvy")
    public suspend fun adminRoleValues(vararg values: Output<String>) {
        this.adminRoleValues = Output.all(values.asList())
    }

    /**
     * @param values The admin role values.
     */
    @JvmName("mpsqwhnclaedcucd")
    public suspend fun adminRoleValues(values: List<Output<String>>) {
        this.adminRoleValues = Output.all(values)
    }

    /**
     * @param value The allowed organizations.
     */
    @JvmName("lbmcilkwjtodjljt")
    public suspend fun allowedOrganizations(`value`: Output<List<String>>) {
        this.allowedOrganizations = value
    }

    @JvmName("iuvrljgghturrtwe")
    public suspend fun allowedOrganizations(vararg values: Output<String>) {
        this.allowedOrganizations = Output.all(values.asList())
    }

    /**
     * @param values The allowed organizations.
     */
    @JvmName("rjodaleixnsnmaui")
    public suspend fun allowedOrganizations(values: List<Output<String>>) {
        this.allowedOrganizations = Output.all(values)
    }

    /**
     * @param value The editor role values.
     */
    @JvmName("mgpqqumppleioohg")
    public suspend fun editorRoleValues(`value`: Output<List<String>>) {
        this.editorRoleValues = value
    }

    @JvmName("vnlessmnmjxdklar")
    public suspend fun editorRoleValues(vararg values: Output<String>) {
        this.editorRoleValues = Output.all(values.asList())
    }

    /**
     * @param values The editor role values.
     */
    @JvmName("ouxglhlvghnediqf")
    public suspend fun editorRoleValues(values: List<Output<String>>) {
        this.editorRoleValues = Output.all(values)
    }

    /**
     * @param value The email assertion.
     */
    @JvmName("pmcoeqilbgjknwlg")
    public suspend fun emailAssertion(`value`: Output<String>) {
        this.emailAssertion = value
    }

    /**
     * @param value The groups assertion.
     */
    @JvmName("asyhbmpuwvmlfkiq")
    public suspend fun groupsAssertion(`value`: Output<String>) {
        this.groupsAssertion = value
    }

    /**
     * @param value The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("erfugpafrprkwjdj")
    public suspend fun idpMetadataUrl(`value`: Output<String>) {
        this.idpMetadataUrl = value
    }

    /**
     * @param value The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("sglpepdjervdunvs")
    public suspend fun idpMetadataXml(`value`: Output<String>) {
        this.idpMetadataXml = value
    }

    /**
     * @param value The login assertion.
     */
    @JvmName("spoinhoidikoggcf")
    public suspend fun loginAssertion(`value`: Output<String>) {
        this.loginAssertion = value
    }

    /**
     * @param value The login validity duration.
     */
    @JvmName("bntyeojmopyvfatx")
    public suspend fun loginValidityDuration(`value`: Output<Int>) {
        this.loginValidityDuration = value
    }

    /**
     * @param value The name assertion.
     */
    @JvmName("sgategatbgyyckia")
    public suspend fun nameAssertion(`value`: Output<String>) {
        this.nameAssertion = value
    }

    /**
     * @param value The org assertion.
     */
    @JvmName("wbjkilheopeexirn")
    public suspend fun orgAssertion(`value`: Output<String>) {
        this.orgAssertion = value
    }

    /**
     * @param value The role assertion.
     */
    @JvmName("hbhgsetdsbykhlwf")
    public suspend fun roleAssertion(`value`: Output<String>) {
        this.roleAssertion = value
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("otxoiwljobfcjajn")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The admin role values.
     */
    @JvmName("rptqymrmcswxondj")
    public suspend fun adminRoleValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminRoleValues = mapped
    }

    /**
     * @param values The admin role values.
     */
    @JvmName("tcflapjiowbfwrvx")
    public suspend fun adminRoleValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminRoleValues = mapped
    }

    /**
     * @param value The allowed organizations.
     */
    @JvmName("pysviddtnyobsaqu")
    public suspend fun allowedOrganizations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrganizations = mapped
    }

    /**
     * @param values The allowed organizations.
     */
    @JvmName("vooocixmdjtsinfe")
    public suspend fun allowedOrganizations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrganizations = mapped
    }

    /**
     * @param value The editor role values.
     */
    @JvmName("kgajmlvxjkvsuokk")
    public suspend fun editorRoleValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.editorRoleValues = mapped
    }

    /**
     * @param values The editor role values.
     */
    @JvmName("gfuumcyjeqarihkj")
    public suspend fun editorRoleValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.editorRoleValues = mapped
    }

    /**
     * @param value The email assertion.
     */
    @JvmName("jynmqhtqecdnyayu")
    public suspend fun emailAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAssertion = mapped
    }

    /**
     * @param value The groups assertion.
     */
    @JvmName("sftdhjjfvkhcpnru")
    public suspend fun groupsAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupsAssertion = mapped
    }

    /**
     * @param value The IDP Metadata URL. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("usosqmsepravqnro")
    public suspend fun idpMetadataUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpMetadataUrl = mapped
    }

    /**
     * @param value The IDP Metadata XML. Note that either `idp_metadata_url` or `idp_metadata_xml` (but not both) must be specified.
     */
    @JvmName("yxtksppeksiwybuh")
    public suspend fun idpMetadataXml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpMetadataXml = mapped
    }

    /**
     * @param value The login assertion.
     */
    @JvmName("vvjnncjdjssgmixm")
    public suspend fun loginAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginAssertion = mapped
    }

    /**
     * @param value The login validity duration.
     */
    @JvmName("fotmsqoysvlayxya")
    public suspend fun loginValidityDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginValidityDuration = mapped
    }

    /**
     * @param value The name assertion.
     */
    @JvmName("pflgjcwoambslxcw")
    public suspend fun nameAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameAssertion = mapped
    }

    /**
     * @param value The org assertion.
     */
    @JvmName("asbockmbsfpjhpmx")
    public suspend fun orgAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orgAssertion = mapped
    }

    /**
     * @param value The role assertion.
     */
    @JvmName("qldsmqpksspjivgj")
    public suspend fun roleAssertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssertion = mapped
    }

    /**
     * @param value The workspace id.
     * The following arguments are optional:
     */
    @JvmName("sjmxceujkbghknbm")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceSamlConfigurationArgs = WorkspaceSamlConfigurationArgs(
        adminRoleValues = adminRoleValues,
        allowedOrganizations = allowedOrganizations,
        editorRoleValues = editorRoleValues,
        emailAssertion = emailAssertion,
        groupsAssertion = groupsAssertion,
        idpMetadataUrl = idpMetadataUrl,
        idpMetadataXml = idpMetadataXml,
        loginAssertion = loginAssertion,
        loginValidityDuration = loginValidityDuration,
        nameAssertion = nameAssertion,
        orgAssertion = orgAssertion,
        roleAssertion = roleAssertion,
        workspaceId = workspaceId,
    )
}
