@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceServiceAccount].
 */
@PulumiTagMarker
public class WorkspaceServiceAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceServiceAccountArgs = WorkspaceServiceAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceServiceAccountArgsBuilder.() -> Unit) {
        val builder = WorkspaceServiceAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceServiceAccount {
        val builtJavaResource = com.pulumi.aws.grafana.WorkspaceServiceAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkspaceServiceAccount(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.grafana.WorkspaceServiceAccount("example", {
 *     name: "example-admin",
 *     grafanaRole: "ADMIN",
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.grafana.WorkspaceServiceAccount("example",
 *     name="example-admin",
 *     grafana_role="ADMIN",
 *     workspace_id=example_aws_grafana_workspace["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Grafana.WorkspaceServiceAccount("example", new()
 *     {
 *         Name = "example-admin",
 *         GrafanaRole = "ADMIN",
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := grafana.NewWorkspaceServiceAccount(ctx, "example", &grafana.WorkspaceServiceAccountArgs{
 * 			Name:        pulumi.String("example-admin"),
 * 			GrafanaRole: pulumi.String("ADMIN"),
 * 			WorkspaceId: pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccount;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkspaceServiceAccount("example", WorkspaceServiceAccountArgs.builder()
 *             .name("example-admin")
 *             .grafanaRole("ADMIN")
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceServiceAccount
 *     properties:
 *       name: example-admin
 *       grafanaRole: ADMIN
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Managed Grafana Workspace Service Account using the `workspace_id` and `service_account_id` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:grafana/workspaceServiceAccount:WorkspaceServiceAccount example g-abc12345,1
 * ```
 */
public class WorkspaceServiceAccount internal constructor(
    override val javaResource: com.pulumi.aws.grafana.WorkspaceServiceAccount,
) : KotlinCustomResource(javaResource, WorkspaceServiceAccountMapper) {
    /**
     * The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
     */
    public val grafanaRole: Output<String>
        get() = javaResource.grafanaRole().applyValue({ args0 -> args0 })

    /**
     * A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the service account in the given Grafana workspace
     */
    public val serviceAccountId: Output<String>
        get() = javaResource.serviceAccountId().applyValue({ args0 -> args0 })

    /**
     * The Grafana workspace with which the service account is associated.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceServiceAccountMapper : ResourceMapper<WorkspaceServiceAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.WorkspaceServiceAccount::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceServiceAccount =
        WorkspaceServiceAccount(javaResource as com.pulumi.aws.grafana.WorkspaceServiceAccount)
}

/**
 * @see [WorkspaceServiceAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceServiceAccount].
 */
public suspend fun workspaceServiceAccount(
    name: String,
    block: suspend WorkspaceServiceAccountResourceBuilder.() -> Unit,
): WorkspaceServiceAccount {
    val builder = WorkspaceServiceAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceServiceAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceServiceAccount(name: String): WorkspaceServiceAccount {
    val builder = WorkspaceServiceAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
