@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceServiceAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.grafana.WorkspaceServiceAccount("example", {
 *     name: "example-admin",
 *     grafanaRole: "ADMIN",
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.grafana.WorkspaceServiceAccount("example",
 *     name="example-admin",
 *     grafana_role="ADMIN",
 *     workspace_id=example_aws_grafana_workspace["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Grafana.WorkspaceServiceAccount("example", new()
 *     {
 *         Name = "example-admin",
 *         GrafanaRole = "ADMIN",
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := grafana.NewWorkspaceServiceAccount(ctx, "example", &grafana.WorkspaceServiceAccountArgs{
 * 			Name:        pulumi.String("example-admin"),
 * 			GrafanaRole: pulumi.String("ADMIN"),
 * 			WorkspaceId: pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccount;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkspaceServiceAccount("example", WorkspaceServiceAccountArgs.builder()
 *             .name("example-admin")
 *             .grafanaRole("ADMIN")
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceServiceAccount
 *     properties:
 *       name: example-admin
 *       grafanaRole: ADMIN
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Managed Grafana Workspace Service Account using the `workspace_id` and `service_account_id` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:grafana/workspaceServiceAccount:WorkspaceServiceAccount example g-abc12345,1
 * ```
 * @property grafanaRole The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
 * @property name A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
 * @property workspaceId The Grafana workspace with which the service account is associated.
 */
public data class WorkspaceServiceAccountArgs(
    public val grafanaRole: Output<String>? = null,
    public val name: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceServiceAccountArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceServiceAccountArgs =
        com.pulumi.aws.grafana.WorkspaceServiceAccountArgs.builder()
            .grafanaRole(grafanaRole?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceServiceAccountArgs].
 */
@PulumiTagMarker
public class WorkspaceServiceAccountArgsBuilder internal constructor() {
    private var grafanaRole: Output<String>? = null

    private var name: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
     */
    @JvmName("gtribbhbyppwnvds")
    public suspend fun grafanaRole(`value`: Output<String>) {
        this.grafanaRole = value
    }

    /**
     * @param value A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
     */
    @JvmName("syfneaujrnmadqgs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Grafana workspace with which the service account is associated.
     */
    @JvmName("hmilssagqdbebvfv")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
     */
    @JvmName("fipqquhayoftyxhu")
    public suspend fun grafanaRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaRole = mapped
    }

    /**
     * @param value A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
     */
    @JvmName("eojkjfgwblfjseew")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Grafana workspace with which the service account is associated.
     */
    @JvmName("vyvvghcmepcjxrbp")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceServiceAccountArgs = WorkspaceServiceAccountArgs(
        grafanaRole = grafanaRole,
        name = name,
        workspaceId = workspaceId,
    )
}
