@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceServiceAccountToken].
 */
@PulumiTagMarker
public class WorkspaceServiceAccountTokenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceServiceAccountTokenArgs = WorkspaceServiceAccountTokenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceServiceAccountTokenArgsBuilder.() -> Unit) {
        val builder = WorkspaceServiceAccountTokenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceServiceAccountToken {
        val builtJavaResource =
            com.pulumi.aws.grafana.WorkspaceServiceAccountToken(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceServiceAccountToken(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.grafana.WorkspaceServiceAccount("example", {
 *     name: "example-admin",
 *     grafanaRole: "ADMIN",
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * const exampleWorkspaceServiceAccountToken = new aws.grafana.WorkspaceServiceAccountToken("example", {
 *     name: "example-key",
 *     serviceAccountId: example.serviceAccountId,
 *     secondsToLive: 3600,
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.grafana.WorkspaceServiceAccount("example",
 *     name="example-admin",
 *     grafana_role="ADMIN",
 *     workspace_id=example_aws_grafana_workspace["id"])
 * example_workspace_service_account_token = aws.grafana.WorkspaceServiceAccountToken("example",
 *     name="example-key",
 *     service_account_id=example.service_account_id,
 *     seconds_to_live=3600,
 *     workspace_id=example_aws_grafana_workspace["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Grafana.WorkspaceServiceAccount("example", new()
 *     {
 *         Name = "example-admin",
 *         GrafanaRole = "ADMIN",
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 *     var exampleWorkspaceServiceAccountToken = new Aws.Grafana.WorkspaceServiceAccountToken("example", new()
 *     {
 *         Name = "example-key",
 *         ServiceAccountId = example.ServiceAccountId,
 *         SecondsToLive = 3600,
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := grafana.NewWorkspaceServiceAccount(ctx, "example", &grafana.WorkspaceServiceAccountArgs{
 * 			Name:        pulumi.String("example-admin"),
 * 			GrafanaRole: pulumi.String("ADMIN"),
 * 			WorkspaceId: pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewWorkspaceServiceAccountToken(ctx, "example", &grafana.WorkspaceServiceAccountTokenArgs{
 * 			Name:             pulumi.String("example-key"),
 * 			ServiceAccountId: example.ServiceAccountId,
 * 			SecondsToLive:    pulumi.Int(3600),
 * 			WorkspaceId:      pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccount;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountArgs;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountToken;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkspaceServiceAccount("example", WorkspaceServiceAccountArgs.builder()
 *             .name("example-admin")
 *             .grafanaRole("ADMIN")
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *         var exampleWorkspaceServiceAccountToken = new WorkspaceServiceAccountToken("exampleWorkspaceServiceAccountToken", WorkspaceServiceAccountTokenArgs.builder()
 *             .name("example-key")
 *             .serviceAccountId(example.serviceAccountId())
 *             .secondsToLive(3600)
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceServiceAccount
 *     properties:
 *       name: example-admin
 *       grafanaRole: ADMIN
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 *   exampleWorkspaceServiceAccountToken:
 *     type: aws:grafana:WorkspaceServiceAccountToken
 *     name: example
 *     properties:
 *       name: example-key
 *       serviceAccountId: ${example.serviceAccountId}
 *       secondsToLive: 3600
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class WorkspaceServiceAccountToken internal constructor(
    override val javaResource: com.pulumi.aws.grafana.WorkspaceServiceAccountToken,
) : KotlinCustomResource(javaResource, WorkspaceServiceAccountTokenMapper) {
    /**
     * Specifies when the service account token was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Specifies when the service account token will expire.
     */
    public val expiresAt: Output<String>
        get() = javaResource.expiresAt().applyValue({ args0 -> args0 })

    /**
     * The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * A name for the token to create. The name must be unique within the workspace.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
     */
    public val secondsToLive: Output<Int>
        get() = javaResource.secondsToLive().applyValue({ args0 -> args0 })

    /**
     * The ID of the service account for which to create a token.
     */
    public val serviceAccountId: Output<String>
        get() = javaResource.serviceAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the service account token in the given Grafana workspace.
     */
    public val serviceAccountTokenId: Output<String>
        get() = javaResource.serviceAccountTokenId().applyValue({ args0 -> args0 })

    /**
     * The Grafana workspace with which the service account token is associated.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceServiceAccountTokenMapper : ResourceMapper<WorkspaceServiceAccountToken> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.grafana.WorkspaceServiceAccountToken::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceServiceAccountToken =
        WorkspaceServiceAccountToken(
            javaResource as
                com.pulumi.aws.grafana.WorkspaceServiceAccountToken,
        )
}

/**
 * @see [WorkspaceServiceAccountToken].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceServiceAccountToken].
 */
public suspend fun workspaceServiceAccountToken(
    name: String,
    block: suspend WorkspaceServiceAccountTokenResourceBuilder.() -> Unit,
): WorkspaceServiceAccountToken {
    val builder = WorkspaceServiceAccountTokenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceServiceAccountToken].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceServiceAccountToken(name: String): WorkspaceServiceAccountToken {
    val builder = WorkspaceServiceAccountTokenResourceBuilder()
    builder.name(name)
    return builder.build()
}
