@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin

import com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.grafana.WorkspaceServiceAccount("example", {
 *     name: "example-admin",
 *     grafanaRole: "ADMIN",
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * const exampleWorkspaceServiceAccountToken = new aws.grafana.WorkspaceServiceAccountToken("example", {
 *     name: "example-key",
 *     serviceAccountId: example.serviceAccountId,
 *     secondsToLive: 3600,
 *     workspaceId: exampleAwsGrafanaWorkspace.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.grafana.WorkspaceServiceAccount("example",
 *     name="example-admin",
 *     grafana_role="ADMIN",
 *     workspace_id=example_aws_grafana_workspace["id"])
 * example_workspace_service_account_token = aws.grafana.WorkspaceServiceAccountToken("example",
 *     name="example-key",
 *     service_account_id=example.service_account_id,
 *     seconds_to_live=3600,
 *     workspace_id=example_aws_grafana_workspace["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Grafana.WorkspaceServiceAccount("example", new()
 *     {
 *         Name = "example-admin",
 *         GrafanaRole = "ADMIN",
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 *     var exampleWorkspaceServiceAccountToken = new Aws.Grafana.WorkspaceServiceAccountToken("example", new()
 *     {
 *         Name = "example-key",
 *         ServiceAccountId = example.ServiceAccountId,
 *         SecondsToLive = 3600,
 *         WorkspaceId = exampleAwsGrafanaWorkspace.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/grafana"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := grafana.NewWorkspaceServiceAccount(ctx, "example", &grafana.WorkspaceServiceAccountArgs{
 * 			Name:        pulumi.String("example-admin"),
 * 			GrafanaRole: pulumi.String("ADMIN"),
 * 			WorkspaceId: pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = grafana.NewWorkspaceServiceAccountToken(ctx, "example", &grafana.WorkspaceServiceAccountTokenArgs{
 * 			Name:             pulumi.String("example-key"),
 * 			ServiceAccountId: example.ServiceAccountId,
 * 			SecondsToLive:    pulumi.Int(3600),
 * 			WorkspaceId:      pulumi.Any(exampleAwsGrafanaWorkspace.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccount;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountArgs;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountToken;
 * import com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkspaceServiceAccount("example", WorkspaceServiceAccountArgs.builder()
 *             .name("example-admin")
 *             .grafanaRole("ADMIN")
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *         var exampleWorkspaceServiceAccountToken = new WorkspaceServiceAccountToken("exampleWorkspaceServiceAccountToken", WorkspaceServiceAccountTokenArgs.builder()
 *             .name("example-key")
 *             .serviceAccountId(example.serviceAccountId())
 *             .secondsToLive(3600)
 *             .workspaceId(exampleAwsGrafanaWorkspace.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:grafana:WorkspaceServiceAccount
 *     properties:
 *       name: example-admin
 *       grafanaRole: ADMIN
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 *   exampleWorkspaceServiceAccountToken:
 *     type: aws:grafana:WorkspaceServiceAccountToken
 *     name: example
 *     properties:
 *       name: example-key
 *       serviceAccountId: ${example.serviceAccountId}
 *       secondsToLive: 3600
 *       workspaceId: ${exampleAwsGrafanaWorkspace.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property name A name for the token to create. The name must be unique within the workspace.
 * @property secondsToLive Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
 * @property serviceAccountId The ID of the service account for which to create a token.
 * @property workspaceId The Grafana workspace with which the service account token is associated.
 */
public data class WorkspaceServiceAccountTokenArgs(
    public val name: Output<String>? = null,
    public val secondsToLive: Output<Int>? = null,
    public val serviceAccountId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs> {
    override fun toJava(): com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs =
        com.pulumi.aws.grafana.WorkspaceServiceAccountTokenArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secondsToLive(secondsToLive?.applyValue({ args0 -> args0 }))
            .serviceAccountId(serviceAccountId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceServiceAccountTokenArgs].
 */
@PulumiTagMarker
public class WorkspaceServiceAccountTokenArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secondsToLive: Output<Int>? = null

    private var serviceAccountId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value A name for the token to create. The name must be unique within the workspace.
     */
    @JvmName("xwpddvieoytypmsi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
     */
    @JvmName("pkmmqfybyvobxycp")
    public suspend fun secondsToLive(`value`: Output<Int>) {
        this.secondsToLive = value
    }

    /**
     * @param value The ID of the service account for which to create a token.
     */
    @JvmName("vmjynhssqtgyljun")
    public suspend fun serviceAccountId(`value`: Output<String>) {
        this.serviceAccountId = value
    }

    /**
     * @param value The Grafana workspace with which the service account token is associated.
     */
    @JvmName("gxemsoctfekasleh")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value A name for the token to create. The name must be unique within the workspace.
     */
    @JvmName("wwnskntypwsedrci")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
     */
    @JvmName("difkmmmrmkjorgfp")
    public suspend fun secondsToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondsToLive = mapped
    }

    /**
     * @param value The ID of the service account for which to create a token.
     */
    @JvmName("acomurgeuqewnwkl")
    public suspend fun serviceAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountId = mapped
    }

    /**
     * @param value The Grafana workspace with which the service account token is associated.
     */
    @JvmName("hyyftvfefhnligox")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceServiceAccountTokenArgs = WorkspaceServiceAccountTokenArgs(
        name = name,
        secondsToLive = secondsToLive,
        serviceAccountId = serviceAccountId,
        workspaceId = workspaceId,
    )
}
