@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.inputs

import com.pulumi.aws.grafana.inputs.GetWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkspace.
 * @property tags Tags assigned to the resource
 * @property workspaceId Grafana workspace ID.
 */
public data class GetWorkspacePlainArgs(
    public val tags: Map<String, String>? = null,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.aws.grafana.inputs.GetWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.aws.grafana.inputs.GetWorkspacePlainArgs =
        com.pulumi.aws.grafana.inputs.GetWorkspacePlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var workspaceId: String? = null

    /**
     * @param value Tags assigned to the resource
     */
    @JvmName("regghojcahhnfybj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the resource
     */
    @JvmName("pdnelvfnlxoobbxh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Grafana workspace ID.
     */
    @JvmName("pgtvdfbxbshwency")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspacePlainArgs = GetWorkspacePlainArgs(
        tags = tags,
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
