@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.inputs

import com.pulumi.aws.grafana.inputs.WorkspaceVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
 * @property subnetIds The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
 */
public data class WorkspaceVpcConfigurationArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.grafana.inputs.WorkspaceVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.grafana.inputs.WorkspaceVpcConfigurationArgs =
        com.pulumi.aws.grafana.inputs.WorkspaceVpcConfigurationArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WorkspaceVpcConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceVpcConfigurationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("rnafqlevyaknsnyh")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("uhthspmpqrdvktsl")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("fosiduixpbpxmnoq")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("rbfhnojkxsayurmf")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("allydvfndjfdhexh")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("dekyivgbhcyolgit")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("bjhxyfxenosvgiqj")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("npwcuuijyhxvnqjo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("qeoppgsjqdgdjnkt")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
     */
    @JvmName("tfqhfisrmivgksob")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): WorkspaceVpcConfigurationArgs = WorkspaceVpcConfigurationArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
