@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getWorkspace.
 * @property accountAccessType (Required) Type of account access for the workspace. Valid values are `CURRENT_ACCOUNT` and `ORGANIZATION`. If `ORGANIZATION` is specified, then `organizational_units` must also be present.
 * @property arn ARN of the Grafana workspace.
 * @property authenticationProviders (Required) Authentication providers for the workspace. Valid values are `AWS_SSO`, `SAML`, or both.
 * @property createdDate Creation date of the Grafana workspace.
 * @property dataSources Data sources for the workspace.
 * @property description Workspace description.
 * @property endpoint Endpoint of the Grafana workspace.
 * @property grafanaVersion Version of Grafana running on the workspace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Last updated date of the Grafana workspace.
 * @property name Grafana workspace name.
 * @property notificationDestinations The notification destinations.
 * @property organizationRoleName The role name that the workspace uses to access resources through Amazon Organizations.
 * @property organizationalUnits The Amazon Organizations organizational units that the workspace is authorized to use data sources from.
 * @property permissionType Permission type of the workspace.
 * @property roleArn IAM role ARN that the workspace assumes.
 * @property samlConfigurationStatus
 * @property stackSetName AWS CloudFormation stack set name that provisions IAM roles to be used by the workspace.
 * @property status Status of the Grafana workspace.
 * @property tags Tags assigned to the resource
 * @property workspaceId
 */
public data class GetWorkspaceResult(
    public val accountAccessType: String,
    public val arn: String,
    public val authenticationProviders: List<String>,
    public val createdDate: String,
    public val dataSources: List<String>,
    public val description: String,
    public val endpoint: String,
    public val grafanaVersion: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
    public val notificationDestinations: List<String>,
    public val organizationRoleName: String,
    public val organizationalUnits: List<String>,
    public val permissionType: String,
    public val roleArn: String,
    public val samlConfigurationStatus: String,
    public val stackSetName: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val workspaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.grafana.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            accountAccessType = javaType.accountAccessType(),
            arn = javaType.arn(),
            authenticationProviders = javaType.authenticationProviders().map({ args0 -> args0 }),
            createdDate = javaType.createdDate(),
            dataSources = javaType.dataSources().map({ args0 -> args0 }),
            description = javaType.description(),
            endpoint = javaType.endpoint(),
            grafanaVersion = javaType.grafanaVersion(),
            id = javaType.id(),
            lastUpdatedDate = javaType.lastUpdatedDate(),
            name = javaType.name(),
            notificationDestinations = javaType.notificationDestinations().map({ args0 -> args0 }),
            organizationRoleName = javaType.organizationRoleName(),
            organizationalUnits = javaType.organizationalUnits().map({ args0 -> args0 }),
            permissionType = javaType.permissionType(),
            roleArn = javaType.roleArn(),
            samlConfigurationStatus = javaType.samlConfigurationStatus(),
            stackSetName = javaType.stackSetName(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
