@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.grafana.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property prefixListIds An array of prefix list IDs.
 * @property vpceIds An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
 */
public data class WorkspaceNetworkAccessControl(
    public val prefixListIds: List<String>,
    public val vpceIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.grafana.outputs.WorkspaceNetworkAccessControl): WorkspaceNetworkAccessControl = WorkspaceNetworkAccessControl(
            prefixListIds = javaType.prefixListIds().map({ args0 -> args0 }),
            vpceIds = javaType.vpceIds().map({ args0 -> args0 }),
        )
    }
}
