@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasources
import com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasources.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Detector].
 */
@PulumiTagMarker
public class DetectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DetectorArgs = DetectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DetectorArgsBuilder.() -> Unit) {
        val builder = DetectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Detector {
        val builtJavaResource = com.pulumi.aws.guardduty.Detector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Detector(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an Amazon GuardDuty detector.
 * > **NOTE:** Deleting this resource is equivalent to "disabling" GuardDuty for an AWS region, which removes all existing findings. You can set the `enable` attribute to `false` to instead "suspend" monitoring and feedback reporting while keeping existing data. See the [Suspending or Disabling Amazon GuardDuty documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_suspend-disable.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDetector = new aws.guardduty.Detector("MyDetector", {
 *     enable: true,
 *     datasources: {
 *         s3Logs: {
 *             enable: true,
 *         },
 *         kubernetes: {
 *             auditLogs: {
 *                 enable: false,
 *             },
 *         },
 *         malwareProtection: {
 *             scanEc2InstanceWithFindings: {
 *                 ebsVolumes: {
 *                     enable: true,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_detector = aws.guardduty.Detector("MyDetector",
 *     enable=True,
 *     datasources={
 *         "s3_logs": {
 *             "enable": True,
 *         },
 *         "kubernetes": {
 *             "audit_logs": {
 *                 "enable": False,
 *             },
 *         },
 *         "malware_protection": {
 *             "scan_ec2_instance_with_findings": {
 *                 "ebs_volumes": {
 *                     "enable": True,
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDetector = new Aws.GuardDuty.Detector("MyDetector", new()
 *     {
 *         Enable = true,
 *         Datasources = new Aws.GuardDuty.Inputs.DetectorDatasourcesArgs
 *         {
 *             S3Logs = new Aws.GuardDuty.Inputs.DetectorDatasourcesS3LogsArgs
 *             {
 *                 Enable = true,
 *             },
 *             Kubernetes = new Aws.GuardDuty.Inputs.DetectorDatasourcesKubernetesArgs
 *             {
 *                 AuditLogs = new Aws.GuardDuty.Inputs.DetectorDatasourcesKubernetesAuditLogsArgs
 *                 {
 *                     Enable = false,
 *                 },
 *             },
 *             MalwareProtection = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionArgs
 *             {
 *                 ScanEc2InstanceWithFindings = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs
 *                 {
 *                     EbsVolumes = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs
 *                     {
 *                         Enable = true,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := guardduty.NewDetector(ctx, "MyDetector", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 			Datasources: &guardduty.DetectorDatasourcesArgs{
 * 				S3Logs: &guardduty.DetectorDatasourcesS3LogsArgs{
 * 					Enable: pulumi.Bool(true),
 * 				},
 * 				Kubernetes: &guardduty.DetectorDatasourcesKubernetesArgs{
 * 					AuditLogs: &guardduty.DetectorDatasourcesKubernetesAuditLogsArgs{
 * 						Enable: pulumi.Bool(false),
 * 					},
 * 				},
 * 				MalwareProtection: &guardduty.DetectorDatasourcesMalwareProtectionArgs{
 * 					ScanEc2InstanceWithFindings: &guardduty.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs{
 * 						EbsVolumes: &guardduty.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs{
 * 							Enable: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesAuditLogsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDetector = new Detector("myDetector", DetectorArgs.builder()
 *             .enable(true)
 *             .datasources(DetectorDatasourcesArgs.builder()
 *                 .s3Logs(DetectorDatasourcesS3LogsArgs.builder()
 *                     .enable(true)
 *                     .build())
 *                 .kubernetes(DetectorDatasourcesKubernetesArgs.builder()
 *                     .auditLogs(DetectorDatasourcesKubernetesAuditLogsArgs.builder()
 *                         .enable(false)
 *                         .build())
 *                     .build())
 *                 .malwareProtection(DetectorDatasourcesMalwareProtectionArgs.builder()
 *                     .scanEc2InstanceWithFindings(DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
 *                         .ebsVolumes(DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
 *                             .enable(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDetector:
 *     type: aws:guardduty:Detector
 *     name: MyDetector
 *     properties:
 *       enable: true
 *       datasources:
 *         s3Logs:
 *           enable: true
 *         kubernetes:
 *           auditLogs:
 *             enable: false
 *         malwareProtection:
 *           scanEc2InstanceWithFindings:
 *             ebsVolumes:
 *               enable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty detectors using the detector ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/detector:Detector MyDetector 00b00fd5aecc0ab60a708659477e9617
 * ```
 * The ID of the detector can be retrieved via the [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/guardduty/list-detectors.html) using `aws guardduty list-detectors`.
 */
public class Detector internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.Detector,
) : KotlinCustomResource(javaResource, DetectorMapper) {
    /**
     * The AWS account ID of the GuardDuty detector
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the GuardDuty detector
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Describes which data sources will be enabled for the detector. See Data Sources below for more details. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `aws.guardduty.DetectorFeature` resources.
     */
    public val datasources: Output<DetectorDatasources>
        get() = javaResource.datasources().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
     */
    public val enable: Output<Boolean>?
        get() = javaResource.enable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the frequency of notifications sent for subsequent finding occurrences. If the detector is a GuardDuty member account, the value is determined by the GuardDuty primary account and cannot be modified, otherwise defaults to `SIX_HOURS`. For standalone and GuardDuty primary accounts, it must be configured in this provider to enable drift detection. Valid values for standalone and primary accounts: `FIFTEEN_MINUTES`, `ONE_HOUR`, `SIX_HOURS`. See [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings_cloudwatch.html#guardduty_findings_cloudwatch_notification_frequency) for more information.
     */
    public val findingPublishingFrequency: Output<String>
        get() = javaResource.findingPublishingFrequency().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DetectorMapper : ResourceMapper<Detector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.Detector::class == javaResource::class

    override fun map(javaResource: Resource): Detector = Detector(
        javaResource as
            com.pulumi.aws.guardduty.Detector,
    )
}

/**
 * @see [Detector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Detector].
 */
public suspend fun detector(name: String, block: suspend DetectorResourceBuilder.() -> Unit): Detector {
    val builder = DetectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Detector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun detector(name: String): Detector {
    val builder = DetectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
