@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.DetectorArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorDatasourcesArgs
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorDatasourcesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an Amazon GuardDuty detector.
 * > **NOTE:** Deleting this resource is equivalent to "disabling" GuardDuty for an AWS region, which removes all existing findings. You can set the `enable` attribute to `false` to instead "suspend" monitoring and feedback reporting while keeping existing data. See the [Suspending or Disabling Amazon GuardDuty documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_suspend-disable.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDetector = new aws.guardduty.Detector("MyDetector", {
 *     enable: true,
 *     datasources: {
 *         s3Logs: {
 *             enable: true,
 *         },
 *         kubernetes: {
 *             auditLogs: {
 *                 enable: false,
 *             },
 *         },
 *         malwareProtection: {
 *             scanEc2InstanceWithFindings: {
 *                 ebsVolumes: {
 *                     enable: true,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_detector = aws.guardduty.Detector("MyDetector",
 *     enable=True,
 *     datasources={
 *         "s3_logs": {
 *             "enable": True,
 *         },
 *         "kubernetes": {
 *             "audit_logs": {
 *                 "enable": False,
 *             },
 *         },
 *         "malware_protection": {
 *             "scan_ec2_instance_with_findings": {
 *                 "ebs_volumes": {
 *                     "enable": True,
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDetector = new Aws.GuardDuty.Detector("MyDetector", new()
 *     {
 *         Enable = true,
 *         Datasources = new Aws.GuardDuty.Inputs.DetectorDatasourcesArgs
 *         {
 *             S3Logs = new Aws.GuardDuty.Inputs.DetectorDatasourcesS3LogsArgs
 *             {
 *                 Enable = true,
 *             },
 *             Kubernetes = new Aws.GuardDuty.Inputs.DetectorDatasourcesKubernetesArgs
 *             {
 *                 AuditLogs = new Aws.GuardDuty.Inputs.DetectorDatasourcesKubernetesAuditLogsArgs
 *                 {
 *                     Enable = false,
 *                 },
 *             },
 *             MalwareProtection = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionArgs
 *             {
 *                 ScanEc2InstanceWithFindings = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs
 *                 {
 *                     EbsVolumes = new Aws.GuardDuty.Inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs
 *                     {
 *                         Enable = true,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := guardduty.NewDetector(ctx, "MyDetector", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 			Datasources: &guardduty.DetectorDatasourcesArgs{
 * 				S3Logs: &guardduty.DetectorDatasourcesS3LogsArgs{
 * 					Enable: pulumi.Bool(true),
 * 				},
 * 				Kubernetes: &guardduty.DetectorDatasourcesKubernetesArgs{
 * 					AuditLogs: &guardduty.DetectorDatasourcesKubernetesAuditLogsArgs{
 * 						Enable: pulumi.Bool(false),
 * 					},
 * 				},
 * 				MalwareProtection: &guardduty.DetectorDatasourcesMalwareProtectionArgs{
 * 					ScanEc2InstanceWithFindings: &guardduty.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs{
 * 						EbsVolumes: &guardduty.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs{
 * 							Enable: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesS3LogsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesAuditLogsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDetector = new Detector("myDetector", DetectorArgs.builder()
 *             .enable(true)
 *             .datasources(DetectorDatasourcesArgs.builder()
 *                 .s3Logs(DetectorDatasourcesS3LogsArgs.builder()
 *                     .enable(true)
 *                     .build())
 *                 .kubernetes(DetectorDatasourcesKubernetesArgs.builder()
 *                     .auditLogs(DetectorDatasourcesKubernetesAuditLogsArgs.builder()
 *                         .enable(false)
 *                         .build())
 *                     .build())
 *                 .malwareProtection(DetectorDatasourcesMalwareProtectionArgs.builder()
 *                     .scanEc2InstanceWithFindings(DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
 *                         .ebsVolumes(DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
 *                             .enable(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDetector:
 *     type: aws:guardduty:Detector
 *     name: MyDetector
 *     properties:
 *       enable: true
 *       datasources:
 *         s3Logs:
 *           enable: true
 *         kubernetes:
 *           auditLogs:
 *             enable: false
 *         malwareProtection:
 *           scanEc2InstanceWithFindings:
 *             ebsVolumes:
 *               enable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty detectors using the detector ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/detector:Detector MyDetector 00b00fd5aecc0ab60a708659477e9617
 * ```
 * The ID of the detector can be retrieved via the [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/guardduty/list-detectors.html) using `aws guardduty list-detectors`.
 * @property datasources Describes which data sources will be enabled for the detector. See Data Sources below for more details. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `aws.guardduty.DetectorFeature` resources.
 * @property enable Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
 * @property findingPublishingFrequency Specifies the frequency of notifications sent for subsequent finding occurrences. If the detector is a GuardDuty member account, the value is determined by the GuardDuty primary account and cannot be modified, otherwise defaults to `SIX_HOURS`. For standalone and GuardDuty primary accounts, it must be configured in this provider to enable drift detection. Valid values for standalone and primary accounts: `FIFTEEN_MINUTES`, `ONE_HOUR`, `SIX_HOURS`. See [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings_cloudwatch.html#guardduty_findings_cloudwatch_notification_frequency) for more information.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DetectorArgs(
    public val datasources: Output<DetectorDatasourcesArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val findingPublishingFrequency: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.DetectorArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.DetectorArgs =
        com.pulumi.aws.guardduty.DetectorArgs.builder()
            .datasources(datasources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .findingPublishingFrequency(findingPublishingFrequency?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DetectorArgs].
 */
@PulumiTagMarker
public class DetectorArgsBuilder internal constructor() {
    private var datasources: Output<DetectorDatasourcesArgs>? = null

    private var enable: Output<Boolean>? = null

    private var findingPublishingFrequency: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Describes which data sources will be enabled for the detector. See Data Sources below for more details. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `aws.guardduty.DetectorFeature` resources.
     */
    @JvmName("wgeswdsgslgwcsbg")
    public suspend fun datasources(`value`: Output<DetectorDatasourcesArgs>) {
        this.datasources = value
    }

    /**
     * @param value Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
     */
    @JvmName("svdpnkdaitsrdtye")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Specifies the frequency of notifications sent for subsequent finding occurrences. If the detector is a GuardDuty member account, the value is determined by the GuardDuty primary account and cannot be modified, otherwise defaults to `SIX_HOURS`. For standalone and GuardDuty primary accounts, it must be configured in this provider to enable drift detection. Valid values for standalone and primary accounts: `FIFTEEN_MINUTES`, `ONE_HOUR`, `SIX_HOURS`. See [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings_cloudwatch.html#guardduty_findings_cloudwatch_notification_frequency) for more information.
     */
    @JvmName("dpiytrfurbpternk")
    public suspend fun findingPublishingFrequency(`value`: Output<String>) {
        this.findingPublishingFrequency = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aroxusqduujopcuj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes which data sources will be enabled for the detector. See Data Sources below for more details. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `aws.guardduty.DetectorFeature` resources.
     */
    @JvmName("dsliimbyxqgbjwyg")
    public suspend fun datasources(`value`: DetectorDatasourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasources = mapped
    }

    /**
     * @param argument Describes which data sources will be enabled for the detector. See Data Sources below for more details. [Deprecated](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-feature-object-api-changes-march2023.html) in favor of `aws.guardduty.DetectorFeature` resources.
     */
    @JvmName("hjxrbkckmdgkhurr")
    public suspend fun datasources(argument: suspend DetectorDatasourcesArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorDatasourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.datasources = mapped
    }

    /**
     * @param value Enable monitoring and feedback reporting. Setting to `false` is equivalent to "suspending" GuardDuty. Defaults to `true`.
     */
    @JvmName("oybrrxnokesrscbd")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Specifies the frequency of notifications sent for subsequent finding occurrences. If the detector is a GuardDuty member account, the value is determined by the GuardDuty primary account and cannot be modified, otherwise defaults to `SIX_HOURS`. For standalone and GuardDuty primary accounts, it must be configured in this provider to enable drift detection. Valid values for standalone and primary accounts: `FIFTEEN_MINUTES`, `ONE_HOUR`, `SIX_HOURS`. See [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings_cloudwatch.html#guardduty_findings_cloudwatch_notification_frequency) for more information.
     */
    @JvmName("vkpunleaeuekwkpq")
    public suspend fun findingPublishingFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingPublishingFrequency = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ffducqprvsbvpgyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rfbojnmhuwulfyvy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DetectorArgs = DetectorArgs(
        datasources = datasources,
        enable = enable,
        findingPublishingFrequency = findingPublishingFrequency,
        tags = tags,
    )
}
